
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
hank_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank_hours")
bobby_hours = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bobby_hours")
peggy_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy_hours")

# Set objective function
m.setObjective(9.06 * hank_hours + 5.38 * bobby_hours + 9.94 * peggy_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(6.31 * hank_hours + 14.73 * bobby_hours >= 56, "work_quality_hank_bobby")
m.addConstr(6.31 * hank_hours + 14.73 * bobby_hours + 14.29 * peggy_hours >= 56, "work_quality_all")
m.addConstr(17.26 * hank_hours + 19.79 * bobby_hours >= 27, "likelihood_to_quit_hank_bobby")
m.addConstr(17.26 * hank_hours + 19.79 * bobby_hours + 9.37 * peggy_hours >= 27, "likelihood_to_quit_all")
m.addConstr(5.05 * bobby_hours + 19.88 * peggy_hours >= 30, "dollar_cost_bobby_peggy")
m.addConstr(15.74 * hank_hours + 19.88 * peggy_hours >= 44, "dollar_cost_hank_peggy")
m.addConstr(15.74 * hank_hours + 5.05 * bobby_hours + 19.88 * peggy_hours >= 44, "dollar_cost_all")
m.addConstr(9.25 * hank_hours + 2.08 * peggy_hours >= 22, "organization_score_hank_peggy")
m.addConstr(16.92 * bobby_hours + 2.08 * peggy_hours >= 42, "organization_score_bobby_peggy")
m.addConstr(9.25 * hank_hours + 16.92 * bobby_hours + 2.08 * peggy_hours >= 42, "organization_score_all")
m.addConstr(2.6 * hank_hours + 17.17 * peggy_hours >= 38, "productivity_rating_hank_peggy")
m.addConstr(2.6 * hank_hours + 0.19 * bobby_hours + 17.17 * peggy_hours >= 49, "productivity_rating_all")
m.addConstr(-6 * hank_hours + 6 * bobby_hours >= 0, "hank_bobby_relation")
m.addConstr(9.25 * hank_hours + 2.08 * peggy_hours <= 77, "organization_score_hank_peggy_upper")
m.addConstr(2.6 * hank_hours + 0.19 * bobby_hours + 17.17 * peggy_hours <= 159, "productivity_rating_all_upper")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Hank Hours: %g' % hank_hours.x)
    print('Bobby Hours: %g' % bobby_hours.x)
    print('Peggy Hours: %g' % peggy_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
