
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b1")
vitamin_d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_d")
zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")
vitamin_b9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")
vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")

# Set objective function
m.setObjective(3.57 * vitamin_b1 + 7.75 * vitamin_d + 7.95 * zinc + 8.59 * vitamin_b9 + 9.65 * vitamin_b7, gp.GRB.MAXIMIZE)

# Add resource constraints
m.addConstr(1 * vitamin_b1 + 8 * vitamin_d + 10 * zinc + 10 * vitamin_b9 + 13 * vitamin_b7 <= 166, "digestive_support")
m.addConstr(7 * vitamin_b1 + 10 * vitamin_d + 9 * zinc + 3 * vitamin_b9 + 8 * vitamin_b7 <= 164, "cardiovascular_support")
m.addConstr(4 * vitamin_b1 + 1 * vitamin_d + 6 * zinc + 9 * vitamin_b9 + 5 * vitamin_b7 <= 351, "muscle_growth")


# Add additional constraints
m.addConstr(9 * zinc + 8 * vitamin_b7 >= 19, "c1")
m.addConstr(9 * zinc + 3 * vitamin_b9 >= 30, "c2")
m.addConstr(3 * vitamin_b9 + 8 * vitamin_b7 >= 27, "c3")
m.addConstr(10 * vitamin_d + 3 * vitamin_b9 >= 32, "c4")
m.addConstr(7 * vitamin_b1 + 8 * vitamin_b7 >= 13, "c5")
m.addConstr(10 * vitamin_d + 8 * vitamin_b7 >= 10, "c6")
m.addConstr(10 * vitamin_d + 9 * zinc + 3 * vitamin_b9 >= 16, "c7")
m.addConstr(9 * vitamin_b9 + 5 * vitamin_b7 >= 43, "c8")
m.addConstr(4 * vitamin_b1 + 9 * vitamin_b9 >= 48, "c9")
m.addConstr(6 * zinc + 9 * vitamin_b9 >= 34, "c10")
m.addConstr(6 * zinc + 5 * vitamin_b7 >= 62, "c11")
m.addConstr(1 * vitamin_d + 6 * zinc >= 46, "c12")
m.addConstr(4 * vitamin_b1 + 6 * zinc + 5 * vitamin_b7 >= 37, "c13")
m.addConstr(4 * vitamin_b1 + 1 * vitamin_d + 9 * vitamin_b9 >= 37, "c14")
m.addConstr(4 * vitamin_b1 + 6 * zinc + 5 * vitamin_b7 >= 45, "c15")
m.addConstr(4 * vitamin_b1 + 1 * vitamin_d + 9 * vitamin_b9 >= 45, "c16")
m.addConstr(1 * vitamin_b1 + 10 * zinc <= 133, "c17")
m.addConstr(10 * zinc + 10 * vitamin_b9 <= 41, "c18")
m.addConstr(8 * vitamin_d + 10 * zinc <= 94, "c19")
m.addConstr(8 * vitamin_d + 13 * vitamin_b7 <= 86, "c20")
m.addConstr(10 * vitamin_b9 + 13 * vitamin_b7 <= 131, "c21")
m.addConstr(1 * vitamin_b1 + 8 * vitamin_d + 10 * zinc + 10 * vitamin_b9 + 13 * vitamin_b7 <= 131, "c22")
m.addConstr(7 * vitamin_b1 + 3 * vitamin_b9 <= 102, "c23")
m.addConstr(7 * vitamin_b1 + 10 * vitamin_d <= 60, "c24")
m.addConstr(9 * zinc + 8 * vitamin_b7 <= 104, "c25")
m.addConstr(7 * vitamin_b1 + 8 * vitamin_b7 <= 105, "c26")
m.addConstr(10 * vitamin_d + 3 * vitamin_b9 <= 114, "c27")
m.addConstr(10 * vitamin_d + 9 * zinc <= 142, "c28")
m.addConstr(7 * vitamin_b1 + 9 * zinc <= 52, "c29")
m.addConstr(3 * vitamin_b9 + 8 * vitamin_b7 <= 124, "c30")
m.addConstr(7 * vitamin_b1 + 10 * vitamin_d + 9 * zinc + 3 * vitamin_b9 + 8 * vitamin_b7 <= 124, "c31")
m.addConstr(6 * zinc + 5 * vitamin_b7 <= 232, "c32")
m.addConstr(4 * vitamin_b1 + 5 * vitamin_b7 <= 139, "c33")
m.addConstr(1 * vitamin_d + 6 * zinc <= 200, "c34")
m.addConstr(4 * vitamin_b1 + 9 * vitamin_b9 <= 83, "c35")
m.addConstr(4 * vitamin_b1 + 6 * zinc <= 260, "c36")
m.addConstr(4 * vitamin_b1 + 1 * vitamin_d <= 349, "c37")
m.addConstr(4 * vitamin_b1 + 1 * vitamin_d + 6 * zinc + 9 * vitamin_b9 + 5 * vitamin_b7 <= 349, "c38")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)
