
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="vitamin_B1", lb=0)  # milligrams of vitamin B1
x1 = m.addVar(name="vitamin_D", lb=0)  # milligrams of vitamin D
x2 = m.addVar(name="zinc", lb=0)  # milligrams of zinc
x3 = m.addVar(name="vitamin_B9", lb=0)  # milligrams of vitamin B9
x4 = m.addVar(name="vitamin_B7", lb=0)  # milligrams of vitamin B7

# Objective function
m.setObjective(3.57*x0 + 7.75*x1 + 7.95*x2 + 8.59*x3 + 9.65*x4, gp.GRB.MAXIMIZE)

# Digestive support index constraint
m.addConstr(1*x0 + 8*x1 + 10*x2 + 10*x3 + 13*x4 <= 166)

# Cardiovascular support index constraint
m.addConstr(7*x0 + 10*x1 + 9*x2 + 3*x3 + 8*x4 <= 164)

# Muscle growth index constraint
m.addConstr(4*x0 + 1*x1 + 6*x2 + 9*x3 + 5*x4 <= 351)

# Additional constraints
m.addConstr(9*x2 + 8*x4 >= 19)
m.addConstr(9*x2 + 3*x3 >= 30)
m.addConstr(3*x3 + 8*x4 >= 27)
m.addConstr(10*x1 + 3*x3 >= 32)
m.addConstr(7*x0 + 8*x4 >= 13)
m.addConstr(10*x1 + 8*x4 >= 10)
m.addConstr(10*x1 + 9*x2 + 3*x3 >= 16)
m.addConstr(9*x3 + 5*x4 >= 43)
m.addConstr(4*x0 + 9*x3 >= 48)
m.addConstr(6*x2 + 9*x3 >= 34)
m.addConstr(6*x2 + 5*x4 >= 62)
m.addConstr(1*x1 + 6*x2 >= 46)
m.addConstr(4*x0 + 6*x2 + 5*x4 >= 37)
m.addConstr(4*x0 + 1*x1 + 9*x3 >= 37)
m.addConstr(4*x0 + 6*x2 + 5*x4 >= 45)
m.addConstr(4*x0 + 1*x1 + 9*x3 >= 45)
m.addConstr(1*x0 + 10*x2 <= 133)
m.addConstr(10*x2 + 10*x3 <= 41)
m.addConstr(8*x1 + 10*x2 <= 94)
m.addConstr(8*x1 + 13*x4 <= 86)
m.addConstr(10*x3 + 13*x4 <= 131)
m.addConstr(1*x0 + 8*x1 + 10*x2 + 10*x3 + 13*x4 <= 131)
m.addConstr(7*x0 + 3*x3 <= 102)
m.addConstr(7*x0 + 10*x1 <= 60)
m.addConstr(9*x2 + 8*x4 <= 104)
m.addConstr(7*x0 + 8*x4 <= 105)
m.addConstr(10*x1 + 3*x3 <= 114)
m.addConstr(10*x1 + 9*x2 <= 142)
m.addConstr(7*x0 + 9*x2 <= 52)
m.addConstr(3*x3 + 8*x4 <= 124)
m.addConstr(7*x0 + 10*x1 + 9*x2 + 3*x3 + 8*x4 <= 124)
m.addConstr(6*x2 + 5*x4 <= 232)
m.addConstr(4*x0 + 5*x4 <= 139)
m.addConstr(1*x1 + 6*x2 <= 200)
m.addConstr(4*x0 + 9*x3 <= 83)
m.addConstr(4*x0 + 6*x2 <= 260)
m.addConstr(4*x0 + 1*x1 <= 349)
m.addConstr(4*x0 + 1*x1 + 6*x2 + 9*x3 + 5*x4 <= 349)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Vitamin B1: ", x0.varValue)
    print("Vitamin D: ", x1.varValue)
    print("Zinc: ", x2.varValue)
    print("Vitamin B9: ", x3.varValue)
    print("Vitamin B7: ", x4.varValue)
else:
    print("The model is infeasible.")
