
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
fat = m.addVar(name="grams_of_fat", nonneg=True)  # Non-negative constraint
vitamin_c = m.addVar(name="milligrams_of_vitamin_C", nonneg=True) # Non-negative constraint


# Set objective function
m.setObjective(8 * fat + 4 * vitamin_c, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(14 * fat + 12 * vitamin_c >= 21, "digestive_support_lower")
m.addConstr(7 * fat + 15 * vitamin_c >= 38, "cognitive_performance_lower")
m.addConstr(-1 * fat + 6 * vitamin_c >= 0, "custom_constraint")
m.addConstr(14 * fat + 12 * vitamin_c <= 71, "digestive_support_upper")
m.addConstr(7 * fat + 15 * vitamin_c <= 88, "cognitive_performance_upper")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Grams of fat: {fat.x}")
    print(f"Milligrams of vitamin C: {vitamin_c.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

