
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
grams_of_fat = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="grams_of_fat")
milligrams_of_vitamin_C = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_C")

# Define objective function
m.setObjective(8 * grams_of_fat + 4 * milligrams_of_vitamin_C, GRB.MINIMIZE)

# Define constraints
m.addConstr(14 * grams_of_fat + 12 * milligrams_of_vitamin_C >= 21, name="digestive_support_index_min")
m.addConstr(14 * grams_of_fat + 12 * milligrams_of_vitamin_C <= 71, name="digestive_support_index_max")
m.addConstr(7 * grams_of_fat + 15 * milligrams_of_vitamin_C >= 38, name="cognitive_performance_index_min")
m.addConstr(7 * grams_of_fat + 15 * milligrams_of_vitamin_C <= 88, name="cognitive_performance_index_max")
m.addConstr(-1 * grams_of_fat + 6 * milligrams_of_vitamin_C >= 0, name="additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of fat: {grams_of_fat.x}")
    print(f"Milligrams of vitamin C: {milligrams_of_vitamin_C.x}")
else:
    print("No optimal solution found")
