
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define variables
fat = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="fat")
vitamin_c = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="vitamin_c")

# Objective function: Minimize 8 * fat + 4 * vitamin_c
m.setObjective(8 * fat + 4 * vitamin_c, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(14 * fat + 12 * vitamin_c >= 21, name="digestive_support_index_min")
m.addConstr(7 * fat + 15 * vitamin_c >= 38, name="cognitive_performance_index_min")
m.addConstr(-fat + 6 * vitamin_c >= 0, name="fat_vitamin_c_relation")
m.addConstr(14 * fat + 12 * vitamin_c <= 71, name="digestive_support_index_max")
m.addConstr(7 * fat + 15 * vitamin_c <= 88, name="cognitive_performance_index_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Fat: {fat.varValue}")
    print(f"Vitamin C: {vitamin_c.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
