
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Optimization")

# Create variables
hank = model.addVar(lb=0, name="hank", vtype=GRB.CONTINUOUS)
mary = model.addVar(lb=0, name="mary", vtype=GRB.INTEGER)
ringo = model.addVar(lb=0, name="ringo", vtype=GRB.INTEGER)
john = model.addVar(lb=0, name="john", vtype=GRB.INTEGER)

# Set objective function
model.setObjective(8*hank**2 + 5*hank*ringo + 7*hank*john + 5*mary**2 + 4*ringo**2 + 4*john**2 + 3*hank + 6*john, GRB.MAXIMIZE)

# Add constraints
model.addConstr(13*hank + 12*ringo + 1*john >= 77, "c1")
model.addConstr(20*mary + 1*john <= 156, "c2")
model.addConstr(16*hank**2 + 20*mary**2 <= 326, "c3")
model.addConstr(16*hank + 16*ringo <= 404, "c4")
model.addConstr(16*hank**2 + 1*john**2 <= 213, "c5")
model.addConstr(16*ringo + 1*john <= 146, "c6")
model.addConstr(16*hank**2 + 20*mary**2 + 1*john**2 <= 353, "c7")
model.addConstr(16*hank + 20*mary + 16*ringo + 1*john <= 353, "c8")
model.addConstr(4*mary + 12*ringo <= 314, "c9")
model.addConstr(4*mary + 1*john <= 119, "c10")
model.addConstr(13*hank**2 + 1*john**2 <= 97, "c11")
model.addConstr(13*hank**2 + 12*ringo**2 <= 218, "c12")
model.addConstr(13*hank + 4*mary <= 301, "c13")
model.addConstr(13*hank + 4*mary + 12*ringo + 1*john <= 301, "c14")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: ', model.objVal)
    print('Hank: ', hank.x)
    print('Mary: ', mary.x)
    print('Ringo: ', ringo.x)
    print('John: ', john.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

