
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define variables
H = m.addVar(lb=-float('inf'), ub=float('inf'), name="H")
M = m.addVar(lb=-float('inf'), ub=float('inf'), name="M")
R = m.addVar(lb=-float('inf'), ub=float('inf'), vtype=gurobi.GRB.INTEGER, name="R")
J = m.addVar(lb=-float('inf'), ub=float('inf'), vtype=gurobi.GRB.INTEGER, name="J")

# Objective function
m.setObjective(8*H**2 + 5*H*R + 7*H*J + 5*M**2 + 4*R**2 + 4*J**2 + 3*H + 6*J, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(16*H <= 432, name="H_competence")
m.addConstr(13*H <= 335, name="H_productivity")
m.addConstr(20*M <= 432, name="M_competence")
m.addConstr(4*M <= 335, name="M_productivity")
m.addConstr(16*R <= 432, name="R_competence")
m.addConstr(12*R <= 335, name="R_productivity")
m.addConstr(1*J <= 432, name="J_competence")
m.addConstr(1*J <= 335, name="J_productivity")
m.addConstr(13*H + 12*R + 1*J >= 77, name="total_productivity")
m.addConstr(20*M + 1*J <= 156, name="M_J_competence")
m.addConstr(16*H**2 + 20*M**2 <= 326, name="H_M_competence")
m.addConstr(16*H + 16*R <= 404, name="H_R_competence")
m.addConstr(16*H**2 + 1*J**2 <= 213, name="H_J_competence")
m.addConstr(16*R + 1*J <= 146, name="R_J_competence")
m.addConstr(16*H**2 + 20*M**2 + 1*J**2 <= 353, name="H_M_J_competence")
m.addConstr(16*H + 20*M + 16*R + 1*J <= 353, name="total_competence")
m.addConstr(4*M + 12*R <= 314, name="M_R_productivity")
m.addConstr(4*M + 1*J <= 119, name="M_J_productivity")
m.addConstr(13*H**2 + 1*J**2 <= 97, name="H_J_productivity")
m.addConstr(13*H**2 + 12*R**2 <= 218, name="H_R_productivity")
m.addConstr(13*H + 4*M <= 301, name="H_M_productivity")
m.addConstr(13*H + 4*M + 12*R + 1*J <= 301, name="total_productivity")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("H: ", H.varValue)
    print("M: ", M.varValue)
    print("R: ", R.varValue)
    print("J: ", J.varValue)
else:
    print("The model is infeasible")
