
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
fruit_salads = m.addVar(vtype=GRB.INTEGER, name="fruit_salads")
sashimi = m.addVar(vtype=GRB.INTEGER, name="sashimi")
bowls_of_instant_ramen = m.addVar(vtype=GRB.CONTINUOUS, name="bowls_of_instant_ramen")

# Set objective function
m.setObjective(1.17 * fruit_salads**2 + 6.23 * fruit_salads * sashimi + 3.65 * fruit_salads * bowls_of_instant_ramen + 3.75 * sashimi**2 + 1.87 * sashimi * bowls_of_instant_ramen + 6.35 * fruit_salads + 8.12 * sashimi + 2.37 * bowls_of_instant_ramen, GRB.MINIMIZE)

# Add constraints
m.addConstr(3.98 * sashimi + 7.82 * bowls_of_instant_ramen >= 27, "fat_constraint1")
m.addConstr(6.94 * fruit_salads + 7.82 * bowls_of_instant_ramen >= 44, "fat_constraint2")
m.addConstr(6.94 * fruit_salads + 3.98 * sashimi + 7.82 * bowls_of_instant_ramen >= 44, "fat_constraint3")
m.addConstr(6.94 * fruit_salads**2 + 3.98 * sashimi**2 + 7.82 * bowls_of_instant_ramen**2 <= 65, "fat_constraint4")

m.addConstr(5.74 * fruit_salads + 1.66 * bowls_of_instant_ramen >= 20, "iron_constraint1")
m.addConstr(5.74 * fruit_salads + 6.87 * sashimi + 1.66 * bowls_of_instant_ramen >= 40, "iron_constraint2")
m.addConstr(5.74 * fruit_salads**2 + 6.87 * sashimi**2 + 1.66 * bowls_of_instant_ramen**2 <= 122, "iron_constraint3")


m.addConstr(-10 * sashimi + 7 * bowls_of_instant_ramen >= 0, "constraint1")
m.addConstr(-1 * fruit_salads + 5 * sashimi >= 0, "constraint2")


# Resource Constraints (Fat and Iron)
m.addConstr(6.94 * fruit_salads + 3.98 * sashimi + 7.82 * bowls_of_instant_ramen <= 133, "fat_upper_bound")
m.addConstr(5.74 * fruit_salads + 6.87 * sashimi + 1.66 * bowls_of_instant_ramen <= 182, "iron_upper_bound")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('fruit_salads:', fruit_salads.x)
    print('sashimi:', sashimi.x)
    print('bowls_of_instant_ramen:', bowls_of_instant_ramen.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
