
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
vitamin_b6 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b6")
vitamin_b2 = model.addVar(lb=0, vtype=GRB.INTEGER, name="vitamin_b2")
calcium = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="calcium")

# Set objective function
model.setObjective(3.09 * vitamin_b6**2 + 8.41 * vitamin_b6 * calcium + 2.01 * calcium**2 + 8.39 * calcium, GRB.MINIMIZE)

# Add constraints
model.addConstr(16 * vitamin_b6 <= 201, "c0")  # Immune support index constraint for B6 (implicit upper bound)
model.addConstr(20 * vitamin_b2 <= 201, "c1")  # Immune support index constraint for B2 (implicit upper bound)
model.addConstr(22 * calcium <= 201, "c2")  # Immune support index constraint for Calcium (implicit upper bound)

model.addConstr(20 * vitamin_b2 + 22 * calcium >= 52, "c3")
model.addConstr(16 * vitamin_b6 + 20 * vitamin_b2 + 22 * calcium >= 52, "c4")
model.addConstr(16 * vitamin_b6 + 22 * calcium <= 101, "c5")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Vitamin B6: {vitamin_b6.x}")
    print(f"Vitamin B2: {vitamin_b2.x}")
    print(f"Calcium: {calcium.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

