
from gurobipy import *

# Create a new model
m = Model("Immune_Support_Optimization")

# Define variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B6")
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams_of_vitamin_B2")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_calcium")

# Objective function
m.setObjective(3.09 * x0**2 + 8.41 * x0 * x2 + 2.01 * x2**2 + 8.39 * x2, GRB.MINIMIZE)

# Constraints
m.addConstr(20*x1 + 22*x2 >= 52, name="constraint_1")
m.addConstr(16*x0 + 20*x1 + 22*x2 >= 52, name="constraint_2")
m.addConstr(16*x0 + 22*x2 <= 101, name="constraint_3")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B6: {x0.x}")
    print(f"Milligrams of Vitamin B2: {x1.x}")
    print(f"Milligrams of Calcium: {x2.x}")
else:
    print("No optimal solution found")
