
import gurobi

def optimize_nutrition():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    vitamin_B6 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="vitamin_B6")
    vitamin_B2 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="vitamin_B2")
    calcium = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="calcium")

    # Objective function
    model.setObjective(3.09 * vitamin_B6**2 + 8.41 * vitamin_B6 * calcium + 2.01 * calcium**2 + 8.39 * calcium, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(vitamin_B6, '=', 16, name="vitamin_B6_constraint")
    model.addConstr(vitamin_B2, '=', 20, name="vitamin_B2_constraint")
    model.addConstr(calcium, '=', 22, name="calcium_constraint")
    model.addConstr(vitamin_B2 + calcium, '>=', 52, name="B2_calcium_index_constraint")
    model.addConstr(vitamin_B6 + vitamin_B2 + calcium, '>=', 52, name="total_index_constraint")
    model.addConstr(vitamin_B6 + calcium, '<=', 101, name="B6_calcium_index_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B6: {vitamin_B6.varValue}")
        print(f"Milligrams of vitamin B2: {vitamin_B2.varValue}")
        print(f"Milligrams of calcium: {calcium.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_nutrition()
