
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
paul_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul_hours")
ringo_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ringo_hours")

# Set objective function
m.setObjective(4 * paul_hours + 6 * ringo_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * paul_hours + 2 * ringo_hours >= 20, "dollar_cost_min")
m.addConstr(9 * paul_hours + 2 * ringo_hours <= 24, "dollar_cost_max")

m.addConstr(6 * paul_hours + 7 * ringo_hours >= 19, "paperwork_min")
m.addConstr(6 * paul_hours + 7 * ringo_hours <= 32, "paperwork_max")

m.addConstr(5 * paul_hours + 1 * ringo_hours >= 22, "work_quality_min")
m.addConstr(5 * paul_hours + 1 * ringo_hours <= 35, "work_quality_max")

m.addConstr(10 * paul_hours + 7 * ringo_hours >= 16, "organization_min")
m.addConstr(10 * paul_hours + 7 * ringo_hours <= 37, "organization_max")

m.addConstr(3 * paul_hours - 3 * ringo_hours >= 0, "custom_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: Paul = {paul_hours.x}, Ringo = {ringo_hours.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

