
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
hours_worked_by_paul = m.addVar(name="hours_worked_by_paul", lb=0)
hours_worked_by_ringo = m.addVar(name="hours_worked_by_ringo", lb=0)

# Objective function: Minimize 4 * hours_worked_by_paul + 6 * hours_worked_by_ringo
m.setObjective(4 * hours_worked_by_paul + 6 * hours_worked_by_ringo, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(9 * hours_worked_by_paul + 2 * hours_worked_by_ringo >= 20, name="dollar_cost_constraint")
m.addConstr(6 * hours_worked_by_paul + 7 * hours_worked_by_ringo >= 19, name="paperwork_competence_constraint")
m.addConstr(5 * hours_worked_by_paul + hours_worked_by_ringo >= 22, name="work_quality_constraint")
m.addConstr(10 * hours_worked_by_paul + 7 * hours_worked_by_ringo >= 16, name="organization_score_constraint")
m.addConstr(3 * hours_worked_by_paul - 3 * hours_worked_by_ringo >= 0, name="hours_balance_constraint")

m.addConstr(9 * hours_worked_by_paul + 2 * hours_worked_by_ringo <= 24, name="dollar_cost_upper_constraint")
m.addConstr(6 * hours_worked_by_paul + 7 * hours_worked_by_ringo <= 32, name="paperwork_competence_upper_constraint")
m.addConstr(5 * hours_worked_by_paul + hours_worked_by_ringo <= 35, name="work_quality_upper_constraint")
m.addConstr(10 * hours_worked_by_paul + 7 * hours_worked_by_ringo <= 37, name="organization_score_upper_constraint")

# Solve the model
m.solve()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Paul: {hours_worked_by_paul.varValue}")
    print(f"Hours worked by Ringo: {hours_worked_by_ringo.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
