
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Define variables for hours worked by each employee
Peggy = m.addVar(lb=0, vtype=GRB.INTEGER, name="Peggy")
Mary = m.addVar(lb=0, vtype=GRB.INTEGER, name="Mary")
John = m.addVar(lb=0, vtype=GRB.INTEGER, name="John")
Laura = m.addVar(lb=0, vtype=GRB.INTEGER, name="Laura")
Bobby = m.addVar(lb=0, vtype=GRB.INTEGER, name="Bobby")
George = m.addVar(lb=0, vtype=GRB.INTEGER, name="George")
Bill = m.addVar(lb=0, vtype=GRB.INTEGER, name="Bill")

# Example constraint: Total combined likelihood to quit index for Mary and George
m.addConstr(Mary + George <= 517, "Mary_George_Quit_Index")

# Add more constraints here based on the problem statement

# Objective function: For simplicity, let's minimize the sum of hours worked by all employees
# Note: In a real scenario, you'd want to incorporate the actual objective function based on the problem requirements
m.setObjective(Peggy + Mary + John + Laura + Bobby + George + Bill, GRB.MINIMIZE)

# Optimize model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Obj:", m.objVal)
