
from gurobipy import *

def solve_optimization_problem():
    # Create a new model
    m = Model()

    # Define the variables
    hours_Peggy = m.addVar(name="hours_Peggy", type=Integer, lowBound=0)
    hours_Mary = m.addVar(name="hours_Mary", type=Integer, lowBound=0)
    hours_John = m.addVar(name="hours_John", type=Integer, lowBound=0)
    hours_Laura = m.addVar(name="hours_Laura", type=Integer, lowBound=0)
    hours_Bobby = m.addVar(name="hours_Bobby", type=Integer, lowBound=0)
    hours_George = m.addVar(name="hours_George", type=Integer, lowBound=0)
    hours_Bill = m.addVar(name="hours_Bill", type=Integer, lowBound=0)

    # Objective function: Maximize 2*Peggy + 1*Mary + 5*John + 9*Laura + 4*Bobby + 9*George + 8*Bill
    m.setObjective(2*hours_Peggy + hours_Mary + 5*hours_John + 9*hours_Laura + 4*hours_Bobby + 9*hours_George + 8*hours_Bill, GRB.MAXIMIZE)

    # Constraints:
    # r0: 
    m.addConstr(8*hours_Peggy + 3*hours_Mary + 7*hours_John + 8*hours_Laura + 4*hours_Bobby + hours_George + 9*hours_Bill <= 476)

    # r1: 
    m.addConstr(11*hours_Peggy + 3*hours_Mary + 2*hours_John + 9*hours_Laura + 10*hours_Bobby + 5*hours_George + 6*hours_Bill <= 474)

    # The total combined productivity rating from hours worked by Peggy, and hours worked by Bill has to be 68 or more.
    m.addConstr(8*hours_Peggy + 9*hours_Bill >= 68)

    # Solve the model
    m.optimize()

    if m.status == GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print("Hours worked by Peggy:", hours_Peggy.varValue)
        print("Hours worked by Mary:", hours_Mary.varValue)
        print("Hours worked by John:", hours_John.varValue)
        print("Hours worked by Laura:", hours_Laura.varValue)
        print("Hours worked by Bobby:", hours_Bobby.varValue)
        print("Hours worked by George:", hours_George.varValue)
        print("Hours worked by Bill:", hours_Bill.varValue)
    else:
        print("No optimal solution found.")

solve_optimization_problem()
