
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
cantaloupes = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cantaloupes")
apples = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apples")
kiwis = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kiwis")
chicken_breasts = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_breasts")

# Set objective function
m.setObjective(6 * cantaloupes + 2 * apples + 2 * kiwis + 8 * chicken_breasts, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20 * cantaloupes + 16 * apples + 9 * kiwis + 19 * chicken_breasts <= 220, "calcium_upper_bound") #r0
m.addConstr(18 * cantaloupes + 18 * apples + 18 * kiwis + 23 * chicken_breasts <= 87, "sourness_upper_bound") #r1
m.addConstr(3 * cantaloupes + 9 * apples + 20 * kiwis + 5 * chicken_breasts <= 290, "cost_upper_bound") #r2

m.addConstr(20 * cantaloupes + 16 * apples + 9 * kiwis >= 31, "calcium_lower_bound")
m.addConstr(3 * cantaloupes + 9 * apples >= 33, "cost_cantaloupes_apples_lower_bound")
m.addConstr(16 * apples + 9 * kiwis <= 146, "calcium_apples_kiwis_upper_bound")
m.addConstr(20 * cantaloupes + 9 * kiwis <= 156, "calcium_cantaloupes_kiwis_upper_bound")
m.addConstr(9 * kiwis + 19 * chicken_breasts <= 150, "calcium_kiwis_chicken_upper_bound")

m.addConstr(20 * cantaloupes + 16 * apples + 9 * kiwis + 19 * chicken_breasts <= 150, "calcium_total_upper_bound")

m.addConstr(18 * cantaloupes + 18 * apples <= 78, "sourness_cantaloupes_apples_upper_bound")
m.addConstr(18 * cantaloupes + 23 * chicken_breasts <= 80, "sourness_cantaloupes_chicken_upper_bound")
m.addConstr(18 * cantaloupes + 18 * apples + 18 * kiwis <= 65, "sourness_cantaloupes_apples_kiwis_upper_bound")
m.addConstr(18 * apples + 18 * kiwis + 23 * chicken_breasts <= 43, "sourness_apples_kiwis_chicken_upper_bound")
m.addConstr(18 * cantaloupes + 18 * kiwis + 23 * chicken_breasts <= 34, "sourness_cantaloupes_kiwis_chicken_upper_bound")
m.addConstr(18 * cantaloupes + 18 * apples + 18 * kiwis + 23 * chicken_breasts <= 34, "sourness_total_upper_bound")

m.addConstr(3 * cantaloupes + 9 * apples <= 224, "cost_cantaloupes_apples_upper_bound")
m.addConstr(9 * apples + 5 * chicken_breasts <= 274, "cost_apples_chicken_upper_bound")
m.addConstr(3 * cantaloupes + 20 * kiwis + 5 * chicken_breasts <= 237, "cost_cantaloupes_kiwis_chicken_upper_bound")
m.addConstr(3 * cantaloupes + 9 * apples + 20 * kiwis + 5 * chicken_breasts <= 237, "cost_total_upper_bound")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

