
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Optimization")

# Create variables
dale_hours = model.addVar(vtype=GRB.INTEGER, name="Dale_Hours")
george_hours = model.addVar(vtype=GRB.INTEGER, name="George_Hours")
john_hours = model.addVar(vtype=GRB.CONTINUOUS, name="John_Hours")
bill_hours = model.addVar(vtype=GRB.INTEGER, name="Bill_Hours")
mary_hours = model.addVar(vtype=GRB.INTEGER, name="Mary_Hours")


# Set objective function
model.setObjective(2 * dale_hours + 8 * george_hours + 9 * john_hours + 5 * bill_hours + 6 * mary_hours, GRB.MAXIMIZE)

# Resource data
resources = {
    'r0': {'description': 'work quality rating', 'upper_bound': 86, 'x0': 3, 'x1': 8, 'x2': 16, 'x3': 6, 'x4': 9},
    'r1': {'description': 'productivity rating', 'upper_bound': 457, 'x0': 12, 'x1': 5, 'x2': 17, 'x3': 9, 'x4': 5},
    'r2': {'description': 'organization score', 'upper_bound': 357, 'x0': 7, 'x1': 9, 'x2': 7, 'x3': 4, 'x4': 12},
    'r3': {'description': 'likelihood to quit index', 'upper_bound': 137, 'x0': 7, 'x1': 15, 'x2': 17, 'x3': 6, 'x4': 2}
}

# Add constraints based on the provided input


model.addConstr(3 * dale_hours + 8 * george_hours + 6 * bill_hours >= 13)
model.addConstr(8 * george_hours + 16 * john_hours + 9 * mary_hours >= 13)
model.addConstr(3 * dale_hours + 8 * george_hours + 9 * mary_hours >= 13)
model.addConstr(3 * dale_hours + 16 * john_hours + 9 * mary_hours >= 13)
model.addConstr(3 * dale_hours + 6 * bill_hours + 9 * mary_hours >= 13)
model.addConstr(3 * dale_hours + 16 * john_hours + 6 * bill_hours >= 13)

model.addConstr(3 * dale_hours + 8 * george_hours + 6 * bill_hours >= 12)
model.addConstr(8 * george_hours + 16 * john_hours + 9 * mary_hours >= 12)
model.addConstr(3 * dale_hours + 8 * george_hours + 9 * mary_hours >= 12)
model.addConstr(3 * dale_hours + 16 * john_hours + 9 * mary_hours >= 12)
model.addConstr(3 * dale_hours + 6 * bill_hours + 9 * mary_hours >= 12)
model.addConstr(3 * dale_hours + 16 * john_hours + 6 * bill_hours >= 12)


model.addConstr(3 * dale_hours + 8 * george_hours + 6 * bill_hours >= 15)
model.addConstr(8 * george_hours + 16 * john_hours + 9 * mary_hours >= 15)
model.addConstr(3 * dale_hours + 8 * george_hours + 9 * mary_hours >= 15)
model.addConstr(3 * dale_hours + 16 * john_hours + 9 * mary_hours >= 15)
model.addConstr(3 * dale_hours + 6 * bill_hours + 9 * mary_hours >= 15)
model.addConstr(3 * dale_hours + 16 * john_hours + 6 * bill_hours >= 15)

model.addConstr(3 * dale_hours + 8 * george_hours + 6 * bill_hours >= 14)
model.addConstr(8 * george_hours + 16 * john_hours + 9 * mary_hours >= 14)
model.addConstr(3 * dale_hours + 8 * george_hours + 9 * mary_hours >= 14)
model.addConstr(3 * dale_hours + 16 * john_hours + 9 * mary_hours >= 14)
model.addConstr(3 * dale_hours + 6 * bill_hours + 9 * mary_hours >= 14)
model.addConstr(3 * dale_hours + 16 * john_hours + 6 * bill_hours >= 14)



model.addConstr(5 * george_hours + 5 * mary_hours >= 67)
model.addConstr(12 * dale_hours + 9 * bill_hours >= 31)
model.addConstr(12 * dale_hours + 5 * george_hours + 17 * john_hours >= 48)
model.addConstr(9 * george_hours + 7 * john_hours + 4 * bill_hours >= 55)
model.addConstr(7 * dale_hours + 2 * mary_hours >= 12)

model.addConstr(3 * dale_hours + 9 * mary_hours <= 72)
model.addConstr(8 * george_hours + 9 * mary_hours <= 38)
model.addConstr(16 * john_hours + 6 * bill_hours <= 20)
model.addConstr(3 * dale_hours + 16 * john_hours + 9 * mary_hours <= 23)
model.addConstr(3 * dale_hours + 8 * george_hours + 16 * john_hours + 6 * bill_hours + 9 * mary_hours <= 23)

model.addConstr(17 * john_hours + 9 * bill_hours <= 208)
model.addConstr(12 * dale_hours + 5 * george_hours <= 323)
model.addConstr(17 * john_hours + 5 * mary_hours <= 128)
model.addConstr(5 * george_hours + 17 * john_hours <= 119)
model.addConstr(12 * dale_hours + 17 * john_hours <= 232)
model.addConstr(5 * george_hours + 9 * bill_hours <= 347)
model.addConstr(9 * bill_hours + 5 * mary_hours <= 312)
model.addConstr(5 * george_hours + 5 * mary_hours <= 436)
model.addConstr(12 * dale_hours + 5 * george_hours + 17 * john_hours + 9 * bill_hours + 5 * mary_hours <= 436)


model.addConstr(9 * george_hours + 4 * bill_hours <= 272)
model.addConstr(9 * george_hours + 7 * john_hours + 12 * mary_hours <= 230)
model.addConstr(7 * john_hours + 4 * bill_hours + 12 * mary_hours <= 252)
model.addConstr(7 * dale_hours + 9 * george_hours + 7 * john_hours <= 86)
model.addConstr(7 * dale_hours + 9 * george_hours + 4 * bill_hours <= 190)
model.addConstr(7 * dale_hours + 7 * john_hours + 12 * mary_hours <= 74)
model.addConstr(9 * george_hours + 4 * bill_hours + 12 * mary_hours <= 181)
model.addConstr(7 * dale_hours + 9 * george_hours + 7 * john_hours + 4 * bill_hours + 12 * mary_hours <= 181)


model.addConstr(7 * dale_hours + 6 * bill_hours <= 122)
model.addConstr(7 * dale_hours + 17 * john_hours <= 70)
model.addConstr(15 * george_hours + 17 * john_hours + 6 * bill_hours <= 125)
model.addConstr(15 * george_hours + 17 * john_hours + 2 * mary_hours <= 82)
model.addConstr(7 * dale_hours + 17 * john_hours + 6 * bill_hours <= 71)
model.addConstr(7 * dale_hours + 6 * bill_hours + 2 * mary_hours <= 105)
model.addConstr(7 * dale_hours + 15 * george_hours + 6 * bill_hours <= 121)
model.addConstr(15 * george_hours + 6 * bill_hours + 2 * mary_hours <= 85)
model.addConstr(7 * dale_hours + 15 * george_hours + 17 * john_hours + 6 * bill_hours + 2 * mary_hours <= 85)



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

