
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
D = m.addVar(name="D", vtype=gp.GRB.INTEGER)  # Integer
G = m.addVar(name="G", vtype=gp.GRB.INTEGER)  # Integer
J = m.addVar(name="J")  # Continuous
B = m.addVar(name="B", vtype=gp.GRB.INTEGER)  # Integer
M = m.addVar(name="M", vtype=gp.GRB.INTEGER)  # Integer

# Objective function
m.setObjective(2*D + 8*G + 9*J + 5*B + 6*M, gp.GRB.MAXIMIZE)

# Constraints
# Work quality rating constraints
m.addConstr(3*D + 8*G + 6*B >= 13)
m.addConstr(8*G + 16*J + 9*M >= 13)
m.addConstr(3*D + 8*G + 9*M >= 13)
m.addConstr(3*D + 16*J + 9*M >= 13)
m.addConstr(3*D + 6*B + 9*M >= 13)
m.addConstr(3*D + 16*J + 6*B >= 13)
m.addConstr(3*D + 8*G + 6*B >= 12)
m.addConstr(8*G + 16*J + 9*M >= 12)
m.addConstr(3*D + 8*G + 9*M >= 12)
m.addConstr(3*D + 16*J + 9*M >= 12)
m.addConstr(3*D + 6*B + 9*M >= 12)
m.addConstr(3*D + 16*J + 6*B >= 12)
m.addConstr(3*D + 8*G + 6*B >= 15)
m.addConstr(8*G + 16*J + 9*M >= 15)
m.addConstr(3*D + 8*G + 9*M >= 15)
m.addConstr(3*D + 16*J + 9*M >= 15)
m.addConstr(3*D + 6*B + 9*M >= 15)
m.addConstr(3*D + 16*J + 6*B >= 15)
m.addConstr(3*D + 8*G + 6*B >= 14)
m.addConstr(8*G + 16*J + 9*M >= 14)
m.addConstr(3*D + 8*G + 9*M >= 14)
m.addConstr(3*D + 16*J + 9*M >= 14)
m.addConstr(3*D + 6*B + 9*M >= 14)
m.addConstr(3*D + 16*J + 6*B >= 14)

# Productivity rating constraints
m.addConstr(5*G + 5*M >= 67)
m.addConstr(12*D + 9*B >= 31)
m.addConstr(12*D + 5*G + 17*J >= 48)
m.addConstr(9*G + 7*J + 4*B >= 55)

# Organization score constraints
m.addConstr(7*G + 9*J + 4*B >= 0)  # Removed as no upper/lower bound given directly
m.addConstr(7*D + 9*G + 7*J + 4*B + 12*M <= 86)
m.addConstr(7*D + 9*G + 4*B <= 190)
m.addConstr(7*D + 7*J + 12*M <= 74)
m.addConstr(9*G + 7*J + 4*B + 12*M <= 181)
m.addConstr(7*D + 9*G + 7*J + 4*B + 12*M <= 181)

# Likelihood to quit index constraints
m.addConstr(7*D + 2*M >= 12)
m.addConstr(7*D + 6*B + 2*M <= 105)
m.addConstr(7*D + 17*J + 6*B <= 71)
m.addConstr(15*G + 17*J + 6*B <= 125)
m.addConstr(15*G + 17*J + 2*M <= 82)
m.addConstr(7*D + 17*J + 6*B <= 71)
m.addConstr(7*D + 6*B + 2*M <= 105)
m.addConstr(7*D + 15*G + 6*B <= 121)
m.addConstr(15*G + 6*B + 2*M <= 85)
m.addConstr(7*D + 15*G + 17*J + 6*B + 2*M <= 85)

# Other constraints
m.addConstr(3*D + 8*G <= 86)
m.addConstr(12*D + 5*G <= 323)
m.addConstr(17*J + 9*B <= 208)
m.addConstr(5*G + 5*M <= 436)
m.addConstr(12*D + 5*G + 17*J + 9*B + 5*M <= 436)
m.addConstr(9*G + 4*B <= 272)
m.addConstr(9*G + 7*J + 12*M <= 230)
m.addConstr(7*J + 4*B + 12*M <= 252)
m.addConstr(7*D + 9*G + 7*J <= 86)

# Work quality rating upper bounds
m.addConstr(3*D + 9*M <= 72)
m.addConstr(8*G + 9*M <= 38)
m.addConstr(16*J + 6*B <= 20)
m.addConstr(3*D + 16*J + 9*M <= 23)
m.addConstr(3*D + 8*G + 16*J + 6*B + 9*M <= 23)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("D:", D.varValue)
    print("G:", G.varValue)
    print("J:", J.varValue)
    print("B:", B.varValue)
    print("M:", M.varValue)
    print("Objective:", m.objVal)
else:
    print("No optimal solution found")
