
import gurobipy as gp

# Create a new model
m = gp.Model("pizza_pie_optimization")

# Create variables
pizza = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="slices_of_pizza")
pie = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cherry_pies")

# Set objective function
m.setObjective(6.19 * pizza + 4.18 * pie, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * pizza + 2 * pie >= 17, "fiber_min")
m.addConstr(5 * pizza + 2 * pie <= 44, "fiber_max") #max fiber

m.addConstr(6 * pizza + 6 * pie >= 36, "cost_min")
m.addConstr(6 * pizza + 6 * pie <= 71, "cost_max") #max cost


m.addConstr(6 * pizza + 1 * pie >= 9, "carbs_min")
m.addConstr(6 * pizza + 1 * pie <= 29, "carbs_max") #max carbs

m.addConstr(5 * pizza + 2 * pie >= 25, "tastiness_min")
m.addConstr(5 * pizza + 2 * pie <= 62, "tastiness_max") #max tastiness

m.addConstr(-8 * pizza + 4 * pie >= 0, "custom_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: Pizza = {pizza.x}, Pie = {pie.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

