
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the decision variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="slices_of_pizza")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="cherry_pies")

# Define the objective function
m.setObjective(6.19*x0 + 4.18*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x0 + 2*x1 >= 17, name="fiber_minimum")
m.addConstr(5*x0 + 2*x1 <= 44, name="fiber_maximum")
m.addConstr(6*x0 + 6*x1 >= 36, name="cost_minimum")
m.addConstr(6*x0 + 6*x1 <= 71, name="cost_maximum")
m.addConstr(6*x0 + 1*x1 >= 9, name="carbohydrates_minimum")
m.addConstr(6*x0 + 1*x1 <= 29, name="carbohydrates_maximum")
m.addConstr(5*x0 + 2*x1 >= 25, name="tastiness_minimum")
m.addConstr(5*x0 + 2*x1 <= 62, name="tastiness_maximum")
m.addConstr(-8*x0 + 4*x1 >= 0, name="additional_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Slices of Pizza:", x0.x)
    print("Cherry Pies:", x1.x)
    print("Objective Function Value:", m.objVal)
else:
    print("No optimal solution found.")

