
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    slices_of_pizza = model.addVar(name="slices_of_pizza", lb=0)
    cherry_pies = model.addVar(name="cherry_pies", lb=0)

    # Define the objective function
    model.setObjective(6.19 * slices_of_pizza + 4.18 * cherry_pies, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(5 * slices_of_pizza + 2 * cherry_pies >= 17, name="fiber_min")
    model.addConstr(5 * slices_of_pizza + 2 * cherry_pies <= 44, name="fiber_max")
    model.addConstr(6 * slices_of_pizza + 6 * cherry_pies >= 36, name="cost_min")
    model.addConstr(6 * slices_of_pizza + 6 * cherry_pies <= 71, name="cost_max")
    model.addConstr(6 * slices_of_pizza + 1 * cherry_pies >= 9, name="carbohydrates_min")
    model.addConstr(6 * slices_of_pizza + 1 * cherry_pies <= 29, name="carbohydrates_max")
    model.addConstr(5 * slices_of_pizza + 2 * cherry_pies >= 25, name="tastiness_min")
    model.addConstr(5 * slices_of_pizza + 2 * cherry_pies <= 62, name="tastiness_max")
    model.addConstr(-8 * slices_of_pizza + 4 * cherry_pies >= 0, name="additional_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Slices of pizza: {slices_of_pizza.varValue}")
        print(f"Cherry pies: {cherry_pies.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
