
from gurobipy import Model, GRB

# Create a new model
model = Model("WorkOptimization")

# Create variables
hank_hours = model.addVar(vtype=GRB.INTEGER, name="hank_hours")
mary_hours = model.addVar(vtype=GRB.INTEGER, name="mary_hours")
dale_hours = model.addVar(vtype=GRB.INTEGER, name="dale_hours")
ringo_hours = model.addVar(vtype=GRB.INTEGER, name="ringo_hours")

# Set objective function
model.setObjective(9.37 * hank_hours + 3.17 * mary_hours + 6.93 * dale_hours + 5.9 * ringo_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(6 * mary_hours + 4 * ringo_hours >= 26, "c0")
model.addConstr(11 * hank_hours + 4 * ringo_hours >= 11, "c1")
model.addConstr(11 * hank_hours + 6 * mary_hours >= 30, "c2")
model.addConstr(6 * mary_hours + 4 * dale_hours >= 28, "c3")
model.addConstr(11 * hank_hours + 4 * dale_hours >= 23, "c4")
model.addConstr(4 * dale_hours + 4 * ringo_hours >= 17, "c5")
model.addConstr(11 * hank_hours + 6 * mary_hours + 4 * dale_hours + 4 * ringo_hours >= 17, "c6")
model.addConstr(8 * hank_hours + 9 * ringo_hours >= 20, "c7")
model.addConstr(8 * hank_hours + 8 * mary_hours >= 13, "c8")
model.addConstr(8 * mary_hours + 6 * dale_hours + 9 * ringo_hours >= 17, "c9")
model.addConstr(8 * hank_hours + 8 * mary_hours + 9 * ringo_hours >= 17, "c10")
model.addConstr(8 * mary_hours + 6 * dale_hours + 9 * ringo_hours >= 11, "c11")
model.addConstr(8 * hank_hours + 8 * mary_hours + 9 * ringo_hours >= 11, "c12")
model.addConstr(8 * hank_hours + 8 * mary_hours + 6 * dale_hours + 9 * ringo_hours >= 11, "c13")
model.addConstr(6 * dale_hours - 7 * ringo_hours >= 0, "c14")
model.addConstr(11 * hank_hours + 6 * mary_hours <= 77, "c15")
model.addConstr(4 * dale_hours + 4 * ringo_hours <= 90, "c16")
model.addConstr(6 * mary_hours + 4 * ringo_hours <= 82, "c17")
model.addConstr(11 * hank_hours + 6 * mary_hours + 4 * dale_hours <= 48, "c18")
model.addConstr(11 * hank_hours + 6 * mary_hours + 4 * ringo_hours <= 88, "c19")
model.addConstr(8 * hank_hours + 9 * ringo_hours <= 28, "c20")
model.addConstr(8 * mary_hours + 9 * ringo_hours <= 40, "c21")
model.addConstr(8 * hank_hours + 8 * mary_hours + 6 * dale_hours <= 63, "c22")
model.addConstr(8 * hank_hours + 8 * mary_hours + 9 * ringo_hours <= 21, "c23")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")
