
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
hours_worked_by_Hank = m.addVar(name="hours_worked_by_Hank", vtype=gp.GRB.INTEGER)
hours_worked_by_Mary = m.addVar(name="hours_worked_by_Mary", vtype=gp.GRB.INTEGER)
hours_worked_by_Dale = m.addVar(name="hours_worked_by_Dale", vtype=gp.GRB.INTEGER)
hours_worked_by_Ringo = m.addVar(name="hours_worked_by_Ringo", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(9.37 * hours_worked_by_Hank + 3.17 * hours_worked_by_Mary + 6.93 * hours_worked_by_Dale + 5.9 * hours_worked_by_Ringo, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(hours_worked_by_Hank * 11 == 11, "Hank_work_quality")
m.addConstr(hours_worked_by_Hank * 8 == 8, "Hank_likelihood_to_quit")
m.addConstr(hours_worked_by_Mary * 6 == 6, "Mary_work_quality")
m.addConstr(hours_worked_by_Mary * 8 == 8, "Mary_likelihood_to_quit")
m.addConstr(hours_worked_by_Dale * 4 == 4, "Dale_work_quality")
m.addConstr(hours_worked_by_Dale * 6 == 6, "Dale_likelihood_to_quit")
m.addConstr(hours_worked_by_Ringo * 4 == 4, "Ringo_work_quality")
m.addConstr(hours_worked_by_Ringo * 9 == 9, "Ringo_likelihood_to_quit")

m.addConstr(6 * hours_worked_by_Mary + 4 * hours_worked_by_Ringo >= 26, "Mary_Ringo_work_quality")
m.addConstr(11 * hours_worked_by_Hank + 4 * hours_worked_by_Ringo >= 11, "Hank_Ringo_work_quality")
m.addConstr(11 * hours_worked_by_Hank + 6 * hours_worked_by_Mary >= 30, "Hank_Mary_work_quality")
m.addConstr(6 * hours_worked_by_Mary + 4 * hours_worked_by_Dale >= 28, "Mary_Dale_work_quality")
m.addConstr(11 * hours_worked_by_Hank + 4 * hours_worked_by_Dale >= 23, "Hank_Dale_work_quality")
m.addConstr(4 * hours_worked_by_Dale + 4 * hours_worked_by_Ringo >= 17, "Dale_Ringo_work_quality")
m.addConstr(11 * hours_worked_by_Hank + 6 * hours_worked_by_Mary + 4 * hours_worked_by_Dale + 4 * hours_worked_by_Ringo >= 17, "all_work_quality")

m.addConstr(8 * hours_worked_by_Hank + 9 * hours_worked_by_Ringo >= 20, "Hank_Ringo_likelihood")
m.addConstr(8 * hours_worked_by_Hank + 8 * hours_worked_by_Mary >= 13, "Hank_Mary_likelihood")
m.addConstr(8 * hours_worked_by_Mary + 6 * hours_worked_by_Dale + 9 * hours_worked_by_Ringo >= 17, "Mary_Dale_Ringo_likelihood")
m.addConstr(8 * hours_worked_by_Hank + 8 * hours_worked_by_Mary + 9 * hours_worked_by_Ringo >= 17, "Hank_Mary_Ringo_likelihood")
m.addConstr(8 * hours_worked_by_Mary + 6 * hours_worked_by_Dale + 9 * hours_worked_by_Ringo >= 11, "Mary_Dale_Ringo_likelihood_2")
m.addConstr(8 * hours_worked_by_Hank + 8 * hours_worked_by_Mary + 9 * hours_worked_by_Ringo >= 11, "Hank_Mary_Ringo_likelihood_2")
m.addConstr(8 * hours_worked_by_Hank + 8 * hours_worked_by_Mary + 6 * hours_worked_by_Dale + 9 * hours_worked_by_Ringo >= 11, "all_likelihood")

m.addConstr(6 * hours_worked_by_Dale - 7 * hours_worked_by_Ringo >= 0, "Dale_Ringo_constraint")

m.addConstr(11 * hours_worked_by_Hank + 6 * hours_worked_by_Mary <= 77, "Hank_Mary_work_quality_max")
m.addConstr(4 * hours_worked_by_Dale + 4 * hours_worked_by_Ringo <= 90, "Dale_Ringo_work_quality_max")
m.addConstr(6 * hours_worked_by_Mary + 4 * hours_worked_by_Ringo <= 82, "Mary_Ringo_work_quality_max")
m.addConstr(11 * hours_worked_by_Hank + 6 * hours_worked_by_Mary + 4 * hours_worked_by_Dale <= 48, "Hank_Mary_Dale_work_quality_max")
m.addConstr(11 * hours_worked_by_Hank + 6 * hours_worked_by_Mary + 4 * hours_worked_by_Ringo <= 88, "Hank_Mary_Ringo_work_quality_max")

m.addConstr(8 * hours_worked_by_Hank + 9 * hours_worked_by_Ringo <= 28, "Hank_Ringo_likelihood_max")
m.addConstr(8 * hours_worked_by_Mary + 9 * hours_worked_by_Ringo <= 40, "Mary_Ringo_likelihood_max")
m.addConstr(8 * hours_worked_by_Hank + 8 * hours_worked_by_Mary + 6 * hours_worked_by_Dale <= 63, "Hank_Mary_Dale_likelihood_max")
m.addConstr(8 * hours_worked_by_Hank + 8 * hours_worked_by_Mary + 9 * hours_worked_by_Ringo <= 21, "Hank_Mary_Ringo_likelihood_max")

# Solve the problem
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Hank: {hours_worked_by_Hank.varValue}")
    print(f"Hours worked by Mary: {hours_worked_by_Mary.varValue}")
    print(f"Hours worked by Dale: {hours_worked_by_Dale.varValue}")
    print(f"Hours worked by Ringo: {hours_worked_by_Ringo.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
