
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    iron = model.addVar(vtype=gp.GRB.INTEGER, name="iron")
    vitamin_b3 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")
    vitamin_b2 = model.addVar(vtype=gp.GRB.INTEGER, name="vitamin_b2")

    # Set objective function
    model.setObjective(3 * iron * vitamin_b3 + 7 * iron * vitamin_b2 + 7 * vitamin_b2 * vitamin_b2 + 6 * vitamin_b2, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(22 * iron * iron + 20 * vitamin_b2 * vitamin_b2 >= 40, "c0")
    model.addConstr(6 * vitamin_b3 + 20 * vitamin_b2 >= 42, "c1")
    model.addConstr(15 * vitamin_b3 + 13 * vitamin_b2 <= 46, "c2")
    model.addConstr(6 * iron * iron + 15 * vitamin_b3 * vitamin_b3 <= 79, "c3")
    model.addConstr(6 * iron + 15 * vitamin_b3 + 13 * vitamin_b2 <= 79, "c4")
    model.addConstr(6 * vitamin_b3 * vitamin_b3 + 20 * vitamin_b2 * vitamin_b2 <= 79, "c5")
    model.addConstr(22 * iron * iron + 6 * vitamin_b3 * vitamin_b3 <= 126, "c6")
    model.addConstr(22 * iron + 6 * vitamin_b3 + 20 * vitamin_b2 <= 49, "c7")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", model.objVal)
        print("Iron:", iron.x)
        print("Vitamin B3:", vitamin_b3.x)
        print("Vitamin B2:", vitamin_b2.x)

except gp.GurobiError as e:
    print(f"Gurobi error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check variable names and model structure.")

