
import gurobi

def optimization_problem():
    model = gurobi.Model()

    x0 = model.addVar(name="milligrams_of_iron", vtype=gurobi.GRB.INTEGER, lb=0)
    x1 = model.addVar(name="milligrams_of_vitamin_B3")
    x2 = model.addVar(name="milligrams_of_vitamin_B2", vtype=gurobi.GRB.INTEGER, lb=0)

    model.setObjective(3*x0*x1 + 7*x0*x2 + 7*x2**2 + 6*x2, gurobi.GRB.MAXIMIZE)

    # Correctly formulated constraints based on problem description
    model.addConstr(x0 == 6)
    model.addConstr(22*x0 <= 130) # Muscle growth index upper bound for x0

    model.addConstr(15*x1 <= 90) # Cognitive performance index upper bound for x1
    model.addConstr(6*x1 <= 130) # Muscle growth index upper bound for x1

    model.addConstr(13*x2 <= 90) # Cognitive performance index upper bound for x2
    model.addConstr(20*x2 <= 130) # Muscle growth index upper bound for x2

    model.addConstr(x0**2 + x2**2 >= 40)
    model.addConstr(6*x1 + 20*x2 >= 42)
    model.addConstr(15*x1 + 13*x2 <= 46)
    model.addConstr(6**2 + x1**2 <= 79)
    model.addConstr(6 + x1 + x2 <= 79)
    model.addConstr(x1**2 + x2**2 <= 79)
    model.addConstr(x0**2 + x1**2 <= 126)
    model.addConstr(x0 + x1 + x2 <= 49)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Milligrams of iron: ", x0.varValue)
        print("Milligrams of vitamin B3: ", x1.varValue)
        print("Milligrams of vitamin B2: ", x2.varValue)
    else:
        print("The model did not converge")

optimization_problem()
