
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
honeypots = m.addVar(vtype=GRB.INTEGER, name="honeypots")
system_administrators = m.addVar(vtype=GRB.INTEGER, name="system_administrators")
automatic_alerts = m.addVar(vtype=GRB.INTEGER, name="automatic_alerts")

# Set objective function
m.setObjective(8 * honeypots**2 + 6 * honeypots * system_administrators + 5 * system_administrators**2 + 3 * system_administrators * automatic_alerts, GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * honeypots + 9 * system_administrators + 1 * automatic_alerts <= 136, "bandwidth_impact")  # r0
m.addConstr(10 * honeypots + 1 * system_administrators + 10 * automatic_alerts <= 68, "latency_impact")  # r1
m.addConstr(9 * honeypots + 1 * system_administrators + 9 * automatic_alerts <= 67, "computational_load")  # r2
m.addConstr(7 * honeypots + 3 * system_administrators + 7 * automatic_alerts <= 47, "data_confidentiality")  # r3
m.addConstr(10 * honeypots + 6 * system_administrators + 4 * automatic_alerts <= 61, "power_consumption")  # r4

m.addConstr(3 * honeypots + 9 * system_administrators >= 31, "min_bandwidth_hp_sa")
m.addConstr(9 * system_administrators + 1 * automatic_alerts >= 25, "min_bandwidth_sa_aa")
m.addConstr(3 * honeypots**2 + 9 * system_administrators**2 + 1 * automatic_alerts**2 >= 43, "min_bandwidth_sq")
m.addConstr(3 * honeypots + 9 * system_administrators + 1 * automatic_alerts >= 43, "min_bandwidth")

m.addConstr(10 * honeypots**2 + 1 * system_administrators**2 >= 9, "min_latency_sq")
m.addConstr(1 * system_administrators + 10 * automatic_alerts >= 21, "min_latency_sa_aa")
m.addConstr(10 * honeypots + 1 * system_administrators + 10 * automatic_alerts >= 21, "min_latency")

m.addConstr(1 * system_administrators + 9 * automatic_alerts >= 16, "min_comp_load_sa_aa")
m.addConstr(9 * honeypots + 1 * system_administrators >= 20, "min_comp_load_hp_sa")
m.addConstr(9 * honeypots + 9 * automatic_alerts >= 13, "min_comp_load_hp_aa")
m.addConstr(9 * honeypots**2 + 1 * system_administrators**2 + 9 * automatic_alerts**2 >= 20, "min_comp_load_sq")
m.addConstr(9 * honeypots + 1 * system_administrators + 9 * automatic_alerts >= 20, "min_comp_load")

m.addConstr(7 * honeypots**2 + 3 * system_administrators**2 >= 8, "min_data_conf_sq")
m.addConstr(7 * honeypots + 3 * system_administrators + 7 * automatic_alerts >= 8, "min_data_confidentiality")

m.addConstr(6 * system_administrators + 4 * automatic_alerts >= 10, "min_power_sa_aa")
m.addConstr(10 * honeypots + 4 * automatic_alerts >= 16, "min_power_hp_aa")
m.addConstr(10 * honeypots + 6 * system_administrators >= 7, "min_power_hp_sa")
m.addConstr(10 * honeypots + 6 * system_administrators + 4 * automatic_alerts >= 7, "min_power")

m.addConstr(5 * honeypots - 8 * automatic_alerts >= 0, "constraint_1")
m.addConstr(-2 * honeypots + 5 * system_administrators >= 0, "constraint_2")

m.addConstr(9 * system_administrators**2 + 1 * automatic_alerts**2 <= 108, "max_bandwidth_sa_aa_sq")
m.addConstr(3 * honeypots**2 + 1 * automatic_alerts**2 <= 117, "max_bandwidth_hp_aa_sq")
m.addConstr(3 * honeypots + 9 * system_administrators + 1 * automatic_alerts <= 101, "max_bandwidth")

m.addConstr(10 * honeypots**2 + 10 * automatic_alerts**2 <= 24, "max_latency_hp_aa_sq")
m.addConstr(10 * honeypots**2 + 1 * system_administrators**2 <= 66, "max_latency_hp_sa_sq")

m.addConstr(7 * honeypots + 3 * system_administrators <= 17, "max_data_conf_hp_sa")
m.addConstr(3 * system_administrators**2 + 7 * automatic_alerts**2 <= 35, "max_data_conf_sa_aa_sq")
m.addConstr(7 * honeypots**2 + 3 * system_administrators**2 + 7 * automatic_alerts**2 <= 34, "max_data_conf_sq")

m.addConstr(10 * honeypots + 4 * automatic_alerts <= 48, "max_power_hp_aa")


# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('honeypots:', honeypots.x)
    print('system_administrators:', system_administrators.x)
    print('automatic_alerts:', automatic_alerts.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

