
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
h = m.addVar(name="honeypots", vtype=gp.GRB.INTEGER)
s = m.addVar(name="system_administrators", vtype=gp.GRB.INTEGER)
a = m.addVar(name="automatic_alerts", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(8 * h ** 2 + 6 * h * s + 5 * s ** 2 + 3 * s * a, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * h + 9 * s + a <= 136)  # available bandwidth impact
m.addConstr(10 * h + s + 10 * a <= 68)  # network latency impact
m.addConstr(9 * h + s + 9 * a <= 67)  # computational load
m.addConstr(7 * h + 3 * s + 7 * a <= 47)  # data confidentiality impact
m.addConstr(10 * h + 6 * s + 4 * a <= 61)  # power consumption
m.addConstr(3 * h + 9 * s >= 31)  # minimum bandwidth used by honeypots and system administrators
m.addConstr(s + a >= 25)  # minimum bandwidth used by system administrators and automatic alerts
m.addConstr(h ** 2 + s ** 2 + a ** 2 >= 43)  # bandwidth usage
m.addConstr(h + s + a >= 43)  # bandwidth usage
m.addConstr(h ** 2 + s ** 2 >= 9)  # network latency from honeypots and system administrators
m.addConstr(s + a >= 21)  # network latency from system administrators and automatic alerts
m.addConstr(h + s + a >= 21)  # network latency
m.addConstr(s + a >= 16)  # computational load from system administrators and automatic alerts
m.addConstr(h + s >= 20)  # computational load from honeypots and system administrators
m.addConstr(h + a >= 13)  # computational load from honeypots and automatic alerts
m.addConstr(h ** 2 + s ** 2 + a ** 2 >= 20)  # computational load
m.addConstr(h + s + a >= 20)  # computational load
m.addConstr(h ** 2 + s ** 2 >= 8)  # data confidentiality impact
m.addConstr(h + s + a >= 8)  # data confidentiality impact
m.addConstr(s + a >= 10)  # power consumption from system administrators and automatic alerts
m.addConstr(h + a >= 16)  # power consumption from honeypots and automatic alerts
m.addConstr(h + s >= 7)  # power consumption from honeypots and system administrators
m.addConstr(h + s + a >= 7)  # power consumption
m.addConstr(5 * h - 8 * a >= 0)  # linear constraint
m.addConstr(-2 * h + 5 * s >= 0)  # linear constraint
m.addConstr(s ** 2 + a ** 2 <= 108)  # bandwidth constraint
m.addConstr(h ** 2 + a ** 2 <= 117)  # bandwidth constraint
m.addConstr(h + s + a <= 101)  # bandwidth constraint
m.addConstr(h ** 2 + a ** 2 <= 24)  # network latency constraint
m.addConstr(h ** 2 + s ** 2 <= 66)  # network latency constraint
m.addConstr(h + s <= 17)  # data confidentiality impact
m.addConstr(s ** 2 + a ** 2 <= 35)  # data confidentiality impact
m.addConstr(h ** 2 + s ** 2 + a ** 2 <= 34)  # data confidentiality impact
m.addConstr(h + a <= 48)  # power consumption

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Honeypots: ", h.varValue)
    print("System Administrators: ", s.varValue)
    print("Automatic Alerts: ", a.varValue)
else:
    print("The model is infeasible")
