
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Hour Optimization")

# Create variables
laura_hours = model.addVar(vtype=GRB.CONTINUOUS, name="laura_hours")
paul_hours = model.addVar(vtype=GRB.INTEGER, name="paul_hours")
jean_hours = model.addVar(vtype=GRB.INTEGER, name="jean_hours")
dale_hours = model.addVar(vtype=GRB.INTEGER, name="dale_hours")

# Set objective function
model.setObjective(5 * laura_hours + 3 * paul_hours + 5 * jean_hours + 9 * dale_hours, GRB.MAXIMIZE)

# Add constraints
model.addConstr(5 * jean_hours + 11 * dale_hours >= 22, "c1")
model.addConstr(2 * laura_hours + 11 * dale_hours >= 13, "c2")
model.addConstr(2 * laura_hours + 5 * jean_hours >= 17, "c3")
model.addConstr(2 * laura_hours + 5 * paul_hours + 5 * jean_hours >= 15, "c4")
model.addConstr(5 * paul_hours + 5 * jean_hours <= 51, "c5")
model.addConstr(2 * laura_hours + 11 * dale_hours <= 72, "c6")
model.addConstr(2 * laura_hours + 5 * paul_hours <= 62, "c7")
model.addConstr(2 * laura_hours + 5 * paul_hours + 5 * jean_hours + 11 * dale_hours <= 89, "c8") # Corrected total score constraint


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Laura Hours: %g' % laura_hours.x)
    print('Paul Hours: %g' % paul_hours.x)
    print('Jean Hours: %g' % jean_hours.x)
    print('Dale Hours: %g' % dale_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % model.status)
