
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
laura_hours = m.addVar(name="laura_hours", lb=0, ub=None)  # Non-integer
paul_hours = m.addVar(name="paul_hours", lb=0, ub=None, integrality=gp.GRB.Integer)  # Integer
jean_hours = m.addVar(name="jean_hours", lb=0, ub=None, integrality=gp.GRB.Integer)  # Integer
dale_hours = m.addVar(name="dale_hours", lb=0, ub=None, integrality=gp.GRB.Integer)  # Integer

# Objective function
m.setObjective(5 * laura_hours + 3 * paul_hours + 5 * jean_hours + 9 * dale_hours, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(2 * laura_hours <= 89, name="laura_score")
m.addConstr(5 * paul_hours <= 89, name="paul_score")
m.addConstr(5 * jean_hours <= 89, name="jean_score")
m.addConstr(11 * dale_hours <= 89, name="dale_score")

m.addConstr(5 * jean_hours + 11 * dale_hours >= 22, name="jean_dale_score")
m.addConstr(2 * laura_hours + 11 * dale_hours >= 13, name="laura_dale_score")
m.addConstr(2 * laura_hours + 5 * jean_hours >= 17, name="laura_jean_score")
m.addConstr(2 * laura_hours + 5 * paul_hours + 5 * jean_hours >= 15, name="laura_paul_jean_score")

m.addConstr(5 * paul_hours + 5 * jean_hours <= 51, name="paul_jean_score_max")
m.addConstr(2 * laura_hours + 11 * dale_hours <= 72, name="laura_dale_score_max")
m.addConstr(2 * laura_hours + 5 * paul_hours <= 62, name="laura_paul_score_max")
m.addConstr(2 * laura_hours + 5 * paul_hours + 5 * jean_hours + 11 * dale_hours <= 62, name="all_score_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Laura's hours: {laura_hours.varValue}")
    print(f"Paul's hours: {paul_hours.varValue}")
    print(f"Jean's hours: {jean_hours.varValue}")
    print(f"Dale's hours: {dale_hours.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
