
import gurobipy as gp

# Create a new model
m = gp.Model("calcium_optimization")

# Create variables
peanutbutter_sandwiches = m.addVar(vtype=gp.GRB.INTEGER, name="peanutbutter_sandwiches")
steaks = m.addVar(vtype=gp.GRB.INTEGER, name="steaks")
strips_of_bacon = m.addVar(vtype=gp.GRB.CONTINUOUS, name="strips_of_bacon")

# Set objective function
m.setObjective(1 * peanutbutter_sandwiches + 6 * steaks + 8 * strips_of_bacon, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2.0 * peanutbutter_sandwiches + 1.04 * strips_of_bacon >= 13, "calcium_constraint1")
m.addConstr(2.0 * peanutbutter_sandwiches + 0.96 * steaks >= 12, "calcium_constraint2")
m.addConstr(2.0 * peanutbutter_sandwiches + 0.96 * steaks + 1.04 * strips_of_bacon >= 12, "calcium_constraint3")
m.addConstr(-10 * steaks + 1 * strips_of_bacon >= 0, "constraint4")
m.addConstr(-2 * peanutbutter_sandwiches + 7 * strips_of_bacon >= 0, "constraint5")
m.addConstr(2.0 * peanutbutter_sandwiches + 0.96 * steaks + 1.04 * strips_of_bacon <= 32, "calcium_constraint6")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('peanutbutter_sandwiches:', peanutbutter_sandwiches.x)
    print('steaks:', steaks.x)
    print('strips_of_bacon:', strips_of_bacon.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

