
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
peanutbutter_sandwiches = m.addVar(vtype=GRB.INTEGER, name="peanutbutter_sandwiches")
steaks = m.addVar(vtype=GRB.INTEGER, name="steaks")
strips_of_bacon = m.addVar(vtype=GRB.CONTINUOUS, name="strips_of_bacon")

# Objective function
m.setObjective(1 * peanutbutter_sandwiches + 6 * steaks + 8 * strips_of_bacon, GRB.MINIMIZE)

# Constraints
# Calcium constraints
m.addConstr(2.0 * peanutbutter_sandwiches + 0.96 * steaks + 1.04 * strips_of_bacon <= 32, name="calcium_upper_bound")
m.addConstr(2.0 * peanutbutter_sandwiches + 1.04 * strips_of_bacon >= 13, name="peanutbutter_and_bacon_calcium")
m.addConstr(2.0 * peanutbutter_sandwiches + 0.96 * steaks >= 12, name="peanutbutter_and_steak_calcium")
m.addConstr(2.0 * peanutbutter_sandwiches + 0.96 * steaks + 1.04 * strips_of_bacon >= 12, name="all_sources_calcium")

# Relationship constraints
m.addConstr(-10 * steaks + 1 * strips_of_bacon >= 0, name="steak_and_bacon_relationship")
m.addConstr(-2 * peanutbutter_sandwiches + 7 * strips_of_bacon >= 0, name="peanutbutter_and_bacon_relationship")

# Non-negativity constraints
m.addConstr(peanutbutter_sandwiches >= 0, name="peanutbutter_non_negative")
m.addConstr(steaks >= 0, name="steak_non_negative")
m.addConstr(strips_of_bacon >= 0, name="bacon_non_negative")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'peanutbutter_sandwiches = {peanutbutter_sandwiches.x}')
    print(f'steaks = {steaks.x}')
    print(f'strips_of_bacon = {strips_of_bacon.x}')
    print(f'Objective value: {m.objVal}')
else:
    print('No optimal solution found')
