
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    peanutbutter_sandwiches = model.addVar(name="peanutbutter_sandwiches", vtype=gurobi.GRB.INTEGER, lb=0)
    steaks = model.addVar(name="steaks", vtype=gurobi.GRB.INTEGER, lb=0)
    strips_of_bacon = model.addVar(name="strips_of_bacon", vtype=gurobi.GRB.CONTINUOUS, lb=0)

    # Objective function
    model.setObjective(peanutbutter_sandwiches + 6 * steaks + 8 * strips_of_bacon, gurobi.GRB.MINIMIZE)

    # Constraints
    # Calcium content
    r0_peanutbutter_sandwiches = 2.0
    r0_steaks = 0.96
    r0_strips_of_bacon = 1.04

    # Minimum calcium intake from peanutbutter sandwiches and strips of bacon
    model.addConstr(r0_peanutbutter_sandwiches * peanutbutter_sandwiches + r0_strips_of_bacon * strips_of_bacon >= 13, name="min_calcium_pb_bacon")

    # Minimum calcium intake from peanutbutter sandwiches and steaks
    model.addConstr(r0_peanutbutter_sandwiches * peanutbutter_sandwiches + r0_steaks * steaks >= 12, name="min_calcium_pb_steak")

    # Minimum calcium intake from all items
    model.addConstr(r0_peanutbutter_sandwiches * peanutbutter_sandwiches + r0_steaks * steaks + r0_strips_of_bacon * strips_of_bacon >= 12, name="min_calcium_all")

    # Linear constraints
    model.addConstr(-10 * steaks + strips_of_bacon >= 0, name="linear_constraint_steak_bacon")
    model.addConstr(-2 * peanutbutter_sandwiches + 7 * strips_of_bacon >= 0, name="linear_constraint_pb_bacon")

    # Maximum calcium intake from all items
    model.addConstr(r0_peanutbutter_sandwiches * peanutbutter_sandwiches + r0_steaks * steaks + r0_strips_of_bacon * strips_of_bacon <= 32, name="max_calcium_all")

    # Upper bound on total calcium
    model.addConstr(r0_peanutbutter_sandwiches * peanutbutter_sandwiches + r0_steaks * steaks + r0_strips_of_bacon * strips_of_bacon <= 70, name="calcium_upper_bound")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Peanutbutter sandwiches: ", peanutbutter_sandwiches.varValue)
        print("Steaks: ", steaks.varValue)
        print("Strips of bacon: ", strips_of_bacon.varValue)
    else:
        print("Model is infeasible")

optimization_problem()
