
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_work_hours")

# Create variables
john_hours = m.addVar(lb=0, name="john_hours")
bobby_hours = m.addVar(lb=0, name="bobby_hours")

# Set objective function
m.setObjective(3 * john_hours + 2 * bobby_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * john_hours + 8 * bobby_hours >= 7, "organization_score_min")
m.addConstr(5 * john_hours + 8 * bobby_hours <= 37, "organization_score_max") #corrected upper bound
m.addConstr(13 * john_hours + 1 * bobby_hours >= 8, "computer_competence_min")
m.addConstr(13 * john_hours + 1 * bobby_hours <= 16, "computer_competence_max")
m.addConstr(4 * john_hours - 8 * bobby_hours >= 0, "john_bobby_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: John's hours = {john_hours.x}, Bobby's hours = {bobby_hours.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

