
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
hours_worked_by_John = m.addVar(lb=0, name="hours_worked_by_John", vtype=GRB.CONTINUOUS)
hours_worked_by_Bobby = m.addVar(lb=0, name="hours_worked_by_Bobby", vtype=GRB.CONTINUOUS)

# Define the objective function
m.setObjective(3*hours_worked_by_John + 2*hours_worked_by_Bobby, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*hours_worked_by_John + 8*hours_worked_by_Bobby >= 7, name="organization_score_min")
m.addConstr(5*hours_worked_by_John + 8*hours_worked_by_Bobby <= 37, name="organization_score_max")
m.addConstr(13*hours_worked_by_John + hours_worked_by_Bobby >= 8, name="computer_rating_min")
m.addConstr(13*hours_worked_by_John + hours_worked_by_Bobby <= 16, name="computer_rating_max")
m.addConstr(4*hours_worked_by_John - 8*hours_worked_by_Bobby >= 0, name="additional_linear_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hours worked by John:", hours_worked_by_John.x)
    print("Hours worked by Bobby:", hours_worked_by_Bobby.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found. Status:", m.status)

