
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x = m.addVar(name="hours_worked_by_John", lb=0)  # Assuming hours cannot be negative
y = m.addVar(name="hours_worked_by_Bobby", lb=0)  # Assuming hours cannot be negative

# Objective function: Minimize 3x + 2y
m.setObjective(3*x + 2*y, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(5*x + 8*y >= 7, name="total_organization_score_min")
m.addConstr(5*x + 8*y <= 37, name="total_organization_score_max")
m.addConstr(13*x + y >= 8, name="total_computer_competence_min")
m.addConstr(13*x + y <= 16, name="total_computer_competence_max")
m.addConstr(4*x - 8*y >= 0, name="linear_constraint")

# Solve the model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by John: {x.varValue}")
    print(f"Hours worked by Bobby: {y.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
