
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_E")
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potassium")
    x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_A")

    # Set objective function
    m.setObjective(8.91 * x0 + 4.08 * x1 + 6.4 * x2, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3.06 * x0 + 3.33 * x1 >= 36, "digestive_constraint1")
    m.addConstr(3.33 * x1 + 3.55 * x2 >= 50, "digestive_constraint2")
    m.addConstr(0.65 * x0 + 0.02 * x1 + 1.68 * x2 >= 48, "kidney_constraint1")
    m.addConstr(3.33 * x1 + 3.55 * x2 <= 113, "digestive_constraint3")
    m.addConstr(3.06 * x0 + 3.33 * x1 <= 114, "digestive_constraint4")
    m.addConstr(3.06 * x0 + 3.33 * x1 + 3.55 * x2 <= 136, "digestive_constraint5")
    m.addConstr(0.65 * x0 + 1.68 * x2 <= 114, "kidney_constraint2")
    m.addConstr(0.65 * x0 + 0.02 * x1 + 1.68 * x2 <= 114, "kidney_constraint3")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Vitamin E: %g' % x0.x)
        print('Potassium: %g' % x1.x)
        print('Vitamin A: %g' % x2.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
