
import gurobi

def optimize():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="milligrams_of_vitamin_E", lb=0, ub=None)  # Vitamin E
    x1 = model.addVar(name="milligrams_of_potassium", lb=0, ub=None)  # Potassium
    x2 = model.addVar(name="milligrams_of_vitamin_A", lb=0, ub=None)  # Vitamin A

    # Objective function
    model.setObjective(8.91 * x0 + 4.08 * x1 + 6.4 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3.06 * x0 + 3.33 * x1 + 3.55 * x2 >= 36, name="digestive_support_min_1")
    model.addConstr(3.33 * x1 + 3.55 * x2 >= 50, name="digestive_support_min_2")
    model.addConstr(0.65 * x0 + 0.02 * x1 + 1.68 * x2 >= 48, name="kidney_support_min")
    model.addConstr(3.33 * x1 + 3.55 * x2 <= 113, name="digestive_support_max_1")
    model.addConstr(3.06 * x0 + 3.33 * x1 <= 114, name="digestive_support_max_2")
    model.addConstr(3.06 * x0 + 3.33 * x1 + 3.55 * x2 <= 136, name="total_digestive_support_max")
    model.addConstr(0.65 * x0 + 1.68 * x2 <= 114, name="kidney_support_max_1")
    model.addConstr(0.65 * x0 + 0.02 * x1 + 1.68 * x2 <= 114, name="kidney_support_max_2")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Milligrams of Vitamin E: {x0.varValue}")
        print(f"Milligrams of Potassium: {x1.varValue}")
        print(f"Milligrams of Vitamin A: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize()
