
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
jean_hours = m.addVar(lb=0, name="jean_hours")
george_hours = m.addVar(lb=0, name="george_hours")
dale_hours = m.addVar(lb=0, name="dale_hours")

# Set objective function
m.setObjective(6.28 * jean_hours**2 + 4.64 * dale_hours**2 + 2.73 * jean_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(george_hours**2 + dale_hours**2 >= 42, "c1")
m.addConstr(7 * jean_hours + 1 * george_hours + 17 * dale_hours >= 42, "c2")
m.addConstr(16 * jean_hours + 10 * george_hours >= 49, "c3")
m.addConstr(16 * jean_hours + 10 * george_hours + 5 * dale_hours >= 49, "c4")
m.addConstr(-4 * jean_hours + 10 * george_hours >= 0, "c5")
m.addConstr(16 * jean_hours + 5 * dale_hours <= 125, "c6")
m.addConstr(10 * george_hours + 5 * dale_hours <= 143, "c7")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Jean Hours: %g' % jean_hours.x)
    print('George Hours: %g' % george_hours.x)
    print('Dale Hours: %g' % dale_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

