
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define decision variables
Jean = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name='hours_worked_by_Jean')
George = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name='hours_worked_by_George')
Dale = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name='hours_worked_by_Dale')

# Objective function
m.setObjective(6.28 * Jean**2 + 4.64 * Dale**2 + 2.73 * Jean, GRB.MINIMIZE)

# Constraints
m.addConstr(Jean * 7 + George * 1 + Dale * 17 >= 42, name='combined_productivity_all')
m.addConstr(George * 1 + Dale * 17 >= 42, name='combined_productivity_GD')
m.addConstr(Jean * 16 + George * 10 >= 49, name='paperwork_competence_JG_min')
m.addConstr(Jean * 16 + George * 10 + Dale * 5 >= 49, name='paperwork_competence_all_min')
m.addConstr(-4 * Jean + 10 * George >= 0, name='linear_constraint')
m.addConstr(Jean * 16 + Dale * 5 <= 125, name='paperwork_competence_JD_max')
m.addConstr(George * 10 + Dale * 5 <= 143, name='paperwork_competence_GD_max')

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Hours worked by Jean: {Jean.x}')
    print(f'Hours worked by George: {George.x}')
    print(f'Hours worked by Dale: {Dale.x}')
else:
    print('No optimal solution found')
