
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hours_worked_by_Jean", lb=0)  # hours worked by Jean
x1 = m.addVar(name="hours_worked_by_George", lb=0)  # hours worked by George
x2 = m.addVar(name="hours_worked_by_Dale", lb=0)  # hours worked by Dale

# Objective function
m.setObjective(6.28 * x0**2 + 4.64 * x2**2 + 2.73 * x0, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(7 * x0 <= 197, name="jean_productivity")
m.addConstr(16 * x0 <= 199, name="jean_paperwork")
m.addConstr(x1 <= 197, name="george_productivity")
m.addConstr(10 * x1 <= 199, name="george_paperwork")
m.addConstr(17 * x2 <= 197, name="dale_productivity")
m.addConstr(5 * x2 <= 199, name="dale_paperwork")

m.addConstr(x1**2 + x2**2 >= 42, name="productivity_rating_min")
m.addConstr(7 * x0 + x1 + 17 * x2 >= 42, name="total_productivity_min")
m.addConstr(16 * x0 + 10 * x1 >= 49, name="paperwork_competence_min_jean_george")
m.addConstr(16 * x0 + 10 * x1 + 5 * x2 >= 49, name="total_paperwork_competence_min")
m.addConstr(-4 * x0 + 10 * x1 >= 0, name="jean_george_work_hours")
m.addConstr(16 * x0 + 5 * x2 <= 125, name="jean_dale_paperwork_max")
m.addConstr(10 * x1 + 5 * x2 <= 143, name="george_dale_paperwork_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Jean: {x0.varValue}")
    print(f"Hours worked by George: {x1.varValue}")
    print(f"Hours worked by Dale: {x2.varValue}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("The model is infeasible.")
