
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("bus_seating")

# Create decision variables
c = m.addVar(lb=0, vtype=GRB.INTEGER, name="cushioned_seats")
r = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular_seats")

# Set objective function
m.setObjective(30*c + 10*r, GRB.MAXIMIZE)

# Add constraints
m.addConstr(c + r <= 150, "total_seats")
m.addConstr(c >= 50, "min_cushioned")
m.addConstr(r >= 2*c, "regular_preference")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of cushioned seats: {c.x}")
    print(f"Number of regular seats: {r.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {m.status}")

