
from gurobipy import *

# Create a new model
m = Model("Bus_Seat_Optimization")

# Define variables
c = m.addVar(name='cushioned_seats', vtype=GRB.CONTINUOUS, lb=0)
r = m.addVar(name='regular_seats', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(30*c + 10*r, GRB.MAXIMIZE)

# Add constraints
m.addConstr(c + r <= 150, name='total_seats')
m.addConstr(c >= 50, name='min_cushioned_seats')
m.addConstr(r >= 2*c, name='regular_vs_cushioned')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cushioned seats: {c.x}")
    print(f"Regular seats: {r.x}")
    print(f"Total profit: ${30*c.x + 10*r.x:.2f}")
else:
    print("No optimal solution found")
