
import gurobi

def solve_seats_allocation():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    C = m.addVar(lb=0, name="Cushioned_Seats")
    R = m.addVar(lb=0, name="Regular_Seats")

    # Objective function: Maximize profit
    m.setObjective(30*C + 10*R, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(C >= 50, name="Min_Cushioned_Seats")
    m.addConstr(R >= 2*C, name="Regular_vs_Cushioned")
    m.addConstr(C + R <= 150, name="Total_Seats")

    # Optimize
    m.optimize()

    # Print solution
    if m.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Cushioned Seats = {C.varValue}, Regular Seats = {R.varValue}")
        print(f"Max Profit: ${30*C.varValue + 10*R.varValue}")
    else:
        print("No optimal solution found.")

solve_seats_allocation()
