
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("packaging_optimization")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="jars")  # jars
y = m.addVar(vtype=GRB.CONTINUOUS, name="plates") # plates

# Set objective
m.setObjective(2*x + 2.5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x + 12*y <= 620, "worker_time")
m.addConstr(3*x + 4*y <= 120, "cardboard")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of jars to package: {x.x:.2f}")
    print(f"Number of plates to package: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

