
from gurobipy import *

# Create a new model
m = Model("Packaging_Optimization")

# Define variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="glass_jars")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="plates")

# Set objective function
m.setObjective(2*x + 2.5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x + 12*y <= 620, "worker_time")
m.addConstr(3*x + 4*y <= 120, "cardboard")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x.varName} = {x.x}, {y.varName} = {y.x}")
    print(f"Maximum profit: ${2*x.x + 2.5*y.x:.2f}")
else:
    print("No optimal solution found")
