
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
jars = model.addVar(lb=0, name="jars", vtype=gurobi.GRB.CONTINUOUS)
plates = model.addVar(lb=0, name="plates", vtype=gurobi.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(2 * jars + 2.5 * plates, gurobi.GRB.MAXIMIZE)

# Define the constraints
worker_time_constraint = model.addConstr(15 * jars + 12 * plates <= 620, name="worker_time_constraint")
cardboard_constraint = model.addConstr(3 * jars + 4 * plates <= 120, name="cardboard_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of jars: {jars.varValue}")
    print(f"Number of plates: {plates.varValue}")
    print(f"Max profit: {model.objVal}")
else:
    print("No optimal solution found.")
