
import gurobipy as gp

# Create a new model
m = gp.Model("MilkTeaOptimization")

# Create variables
x = m.addVar(vtype=gp.GRB.INTEGER, name="black_tea")  # Integer since we can't make fractions of bottles
y = m.addVar(vtype=gp.GRB.INTEGER, name="green_tea")

# Set objective function
m.setObjective(2.5 * x + 7 * y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(300 * x + 200 * y <= 50000, "milk_constraint")
m.addConstr(x >= 3 * y, "black_tea_constraint")
m.addConstr(y >= 10, "green_tea_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Black Milk Tea Bottles: {x.x}")
    print(f"Number of Green Milk Tea Bottles: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

