
from gurobipy import *

# Create a new model
m = Model("Milk_Tea_Optimization")

# Define the variables
B = m.addVar(name='Black_Milk_Tea', vtype=GRB.INTEGER, lb=0)
G = m.addVar(name='Green_Milk_Tea', vtype=GRB.INTEGER, lb=10)

# Set the objective function
m.setObjective(2.5*B + 7*G, GRB.MAXIMIZE)

# Add constraints
m.addConstr(300*B + 200*G <= 50000, name='Milk_Constraint')
m.addConstr(B >= 3*G, name='Black_vs_Green_Constraint')

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Number of Black Milk Tea bottles: {B.x}')
    print(f'Number of Green Milk Tea bottles: {G.x}')
    print(f'Total profit: ${2.5*B.x + 7*G.x:.2f}')
else:
    print('No optimal solution found')
