
import gurobi

def milk_tea_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    B = model.addVar(name="Black_Milk_Tea", lb=0, vtype=gurobi.GRB.INTEGER)
    G = model.addVar(name="Green_Milk_Tea", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(2.5 * B + 7 * G, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(300 * B + 200 * G <= 50000, name="Milk_Constraint")
    model.addConstr(B >= 3 * G, name="Black_vs_Green_Ratio")
    model.addConstr(G >= 10, name="Minimum_Green_Milk_Tea")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Black Milk Tea: {B.varValue}")
        print(f"Green Milk Tea: {G.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

# Run the optimization
milk_tea_optimization()
